<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class JobApplication extends Model
{
    use HasFactory;

    protected $fillable = [
        'job_id',
        'name',
        'email',
        'mobile',
        'cover_letter',
        'resume'
    ];

    // Relationship with career
    public function career()
    {
        return $this->belongsTo(Career::class, 'job_id');
    }
}
