<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Portfolio extends Model
{
    protected $fillable = [
        'title',
        'image',
        'status'
    ];

    // Scope to get only active portfolios
    public function scopeActive($query)
    {
        return $query->where('status', 1);
    }

    // Get the full image URL
    public function getImageUrlAttribute()
    {
        if ($this->image) {
            // If it's already a full URL, return as is
            if (filter_var($this->image, FILTER_VALIDATE_URL)) {
                return $this->image;
            }
            // Otherwise, prepend the storage path
            return asset('storage/' . $this->image);
        }
        // Default image if none provided
        return '/frontend/assets/images/our-client/default-client.jpg';
    }
}
