<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\View;
use App\Service;
use App\Sale;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        // Share services and sales data with all views for footer
        View::composer('*', function ($view) {
            $view->with([
                'services' => Service::active()->get(),
                'sales' => Sale::active()->get()
            ]);
        });
    }
}
