<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Career;

class CareersTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $careers = [
            [
                'job_title' => 'Senior Software Engineer',
                'location' => 'New York, NY',
                'salary' => '$80,000 - $120,000',
                'experience' => '3-5 years',
                'slug' => 'senior-software-engineer',
                'qualification' => 'Bachelor\'s in Computer Science',
                'job_desc' => '<h4>Job Overview</h4><p>We are looking for a Senior Software Engineer to join our dynamic team. You will be responsible for developing high-quality software solutions and mentoring junior developers.</p><h4>Key Responsibilities</h4><ul><li>Design and develop scalable web applications</li><li>Collaborate with cross-functional teams</li><li>Code review and mentoring</li><li>Participate in architectural decisions</li></ul><h4>Requirements</h4><ul><li>3+ years of software development experience</li><li>Proficiency in PHP, Laravel, JavaScript</li><li>Experience with databases (MySQL, PostgreSQL)</li><li>Strong problem-solving skills</li></ul>',
                'status' => 1,
            ],
            [
                'job_title' => 'Frontend Developer',
                'location' => 'San Francisco, CA',
                'salary' => '$60,000 - $90,000',
                'experience' => '2-4 years',
                'slug' => 'frontend-developer',
                'qualification' => 'Bachelor\'s in Web Development or related field',
                'job_desc' => '<h4>Job Overview</h4><p>Join our creative team as a Frontend Developer and help build amazing user experiences for our clients.</p><h4>Key Responsibilities</h4><ul><li>Develop responsive web interfaces</li><li>Implement UI/UX designs</li><li>Optimize applications for speed and scalability</li><li>Collaborate with backend developers</li></ul><h4>Requirements</h4><ul><li>2+ years of frontend development experience</li><li>Proficiency in HTML, CSS, JavaScript</li><li>Experience with React, Vue.js, or Angular</li><li>Knowledge of responsive design principles</li></ul>',
                'status' => 1,
            ],
            [
                'job_title' => 'Digital Marketing Specialist',
                'location' => 'Remote',
                'salary' => '$45,000 - $65,000',
                'experience' => '1-3 years',
                'slug' => 'digital-marketing-specialist',
                'qualification' => 'Bachelor\'s in Marketing or Communications',
                'job_desc' => '<h4>Job Overview</h4><p>We are seeking a creative Digital Marketing Specialist to develop and execute marketing campaigns that drive brand awareness and customer engagement.</p><h4>Key Responsibilities</h4><ul><li>Develop and implement digital marketing strategies</li><li>Manage social media accounts and campaigns</li><li>Create engaging content for various platforms</li><li>Analyze campaign performance and ROI</li></ul><h4>Requirements</h4><ul><li>1+ years of digital marketing experience</li><li>Knowledge of SEO, SEM, and social media marketing</li><li>Experience with Google Analytics and marketing tools</li><li>Excellent written and verbal communication skills</li></ul>',
                'status' => 1,
            ],
            [
                'job_title' => 'Project Manager',
                'location' => 'Chicago, IL',
                'salary' => '$70,000 - $95,000',
                'experience' => '4-6 years',
                'slug' => 'project-manager',
                'qualification' => 'Bachelor\'s degree, PMP certification preferred',
                'job_desc' => '<h4>Job Overview</h4><p>Lead cross-functional teams and manage complex projects from initiation to completion as our Project Manager.</p><h4>Key Responsibilities</h4><ul><li>Plan, execute, and close projects successfully</li><li>Manage project timelines, budgets, and resources</li><li>Coordinate with stakeholders and team members</li><li>Identify and mitigate project risks</li></ul><h4>Requirements</h4><ul><li>4+ years of project management experience</li><li>PMP or similar certification preferred</li><li>Strong leadership and communication skills</li><li>Experience with project management tools (Jira, Asana, etc.)</li></ul>',
                'status' => 1,
            ],
        ];

        foreach ($careers as $career) {
            Career::create($career);
        }
    }
}
