<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Service;

class ServicesTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $services = [
            [
                'title' => 'House Cleaning',
                'slug' => 'house-cleaning',
                'short_desc' => 'Et massa lobortis velit facilisi nulla eu aliquam semper vestibulum. Nunc in morbi phasellus volutpat mi dolor viverra nibh mi.',
                'long_desc' => 'Complete house cleaning service including all rooms, bathrooms, kitchen, and common areas. Our professional team ensures every corner of your house is spotless.',
                'img' => 'slider-img1.jpg',
                'status' => 1,
            ],
            [
                'title' => 'Kitchen Cleaning',
                'slug' => 'kitchen-cleaning',
                'short_desc' => 'Feugiat nec magnis tellus nisl. Ut quam urna magna augue netus volutpat. Habitasse nulla tellus venenatis enim curabitur.',
                'long_desc' => 'Deep kitchen cleaning service including appliances, countertops, cabinets, and floors. We make your kitchen sparkle and sanitized.',
                'img' => 'slider-img2.jpg',
                'status' => 1,
            ],
            [
                'title' => 'Office Cleaning',
                'slug' => 'office-cleaning',
                'short_desc' => 'Lacinia consequat libero etiam non eget ut vel fermentum bibendum. Ullamcorper aliquam mauris venenatis id velit ut.',
                'long_desc' => 'Professional office cleaning services for businesses of all sizes. We maintain a clean and healthy work environment for your employees.',
                'img' => 'slider-img3.jpg',
                'status' => 1,
            ],
            [
                'title' => 'Window Cleaning',
                'slug' => 'window-cleaning',
                'short_desc' => 'Netus vestibulum hendrerit amet nulla erat nulla aliquam magna faucibus. Purus nunc nulla pulvinar in luctus sodales.',
                'long_desc' => 'Crystal clear window cleaning service for residential and commercial properties. We clean both interior and exterior windows.',
                'img' => 'slider-img4.jpg',
                'status' => 1,
            ],
            [
                'title' => 'Corporate Cleaning',
                'slug' => 'corporate-cleaning',
                'short_desc' => 'Feugiat lorem tellus neque ipsum. A cras in pharetra at congue sed nulla ultricies. Tortor risus netus nisl risus ante nibh.',
                'long_desc' => 'Comprehensive corporate cleaning solutions for large businesses and office complexes. Customized cleaning schedules to meet your needs.',
                'img' => 'slider-img5.jpg',
                'status' => 1,
            ],
            [
                'title' => 'Carpet Cleaning',
                'slug' => 'carpet-cleaning',
                'short_desc' => 'Tempus lobortis sit vel eu pellentesque ipsum habitant. Ut posuere arcu venenatis egestas sed hac vel nisi massa interdum lorem.',
                'long_desc' => 'Professional carpet cleaning service using advanced equipment and eco-friendly solutions. We remove stains, odors, and allergens.',
                'img' => 'slider-img6.jpg',
                'status' => 1,
            ],
        ];

        foreach ($services as $service) {
            Service::create($service);
        }
    }
}
