@extends('frontend.layouts.app')

@section('content')
<section class="heroSection">
        <div class="container">
            <h1 class="img-header-text fade_down">Our Blog</h1>
            <div class="breadcrumb-group fade_up">
                <a href="/">HOME / </a>
                <a href="/blog">Blog</a>
            </div>
        </div>
    </section>
    <!-- ====================================== About Section Two ===================================== -->
    <section class="blog-section">
        <div class="container">
            <div class="row blog-two-grid-row">
                <div class="col-xxl-8 col-xl-8 col-lg-8 col-md-12">
                     <div class="row home-blog-row blogPage-row2">
                        @forelse($posts as $post)
                        <div class="col-xxl-6 col-xl-6 col-lg-6 col-md-6">
                            <a href="/blog_detail/{{ $post->slug }}" class="blog-box-main zoom_in">
                                <div class="blog-img-main">
                                    <img class="blog-img" src="{{ asset('storage/' . $post->image) }}" alt="{{ $post->title }}">
                                    <h3 class="blog-date">{{ $post->created_at->format('d M Y') }}</h3>
                                </div>
                                <div class="blog-containe-main">
                                    <h2>{{ $post->title }}</h2>
                                    <p>{{ $post->excerpt ?: Str::limit(strip_tags($post->body), 100) }}</p>
                                </div>
                            </a>
                        </div>
                        @empty
                        <div class="col-12">
                            <div class="text-center">
                                <p>No blog posts available at the moment.</p>
                            </div>
                        </div>
                        @endforelse
                    </div>

                    <!-- Pagination -->
                    @if($posts->hasPages())
                    <div class="d-flex justify-content-center mt-4">
                        {{ $posts->appends(request()->query())->links() }}
                    </div>
                    @endif
                </div>
                <div class="col-xxl-4 col-xl-4 col-lg-4 col-md-8">
                    <div class="search-box-main">
                        <form method="GET" action="{{ route('blog') }}" class="search-input">
                            <input type="text" placeholder="Search Here..." name="search" value="{{ request('search') }}">
                            <button type="submit" class="search-box" style="border: none; background: none; cursor: pointer;">
                                <img src="/frontend/assets/images/svg/search-icon.svg" alt="search-icon">
                            </button>
                        </form>
                    </div>
                    <div class="single-services-black-box" id="recent-post-box">
                        <h3>Recent Posts</h3>
                    </div>
                    @forelse($recentPosts as $recentPost)
                    <a href="/blog_detail/{{ $recentPost->slug }}" class="recent-post-main">
                        <img src="{{ $recentPost->image ? asset('storage/' . $recentPost->image) : '/frontend/assets/images/blog/default-blog.jpg' }}" alt="{{ $recentPost->title }}" width="100px">
                        <div class="recent-post-text-main">
                            <p>{{ $recentPost->created_at->format('d M Y') }}</p>
                            <h2>{{ Str::limit($recentPost->title, 50) }}</h2>
                        </div>
                    </a>
                    @empty
                    <div class="recent-post-main">
                        <div class="recent-post-text-main">
                            <p>No recent posts available</p>
                        </div>
                    </div>
                    @endforelse

                    <!-- Categories Section -->
                    <div class="single-services-black-box" id="categories-box">
                        <h3>Categories</h3>
                    </div>
                    <div class="categories-list">
                        @forelse($categories as $category)
                            <a href="{{ route('blog', ['category' => $category->id]) }}" class="category-link">
                                <div class="category-item">
                                    <h4>{{ $category->name }}</h4>
                                    <span class="post-count">({{ $category->posts()->where('status', 'PUBLISHED')->count() }} posts)</span>
                                </div>
                            </a>
                        @empty
                            <div class="category-item">
                                <p>No categories available</p>
                            </div>
                        @endforelse
                    </div>

                </div>
            </div>
        </div>
    </section>
@stop
