@extends('frontend.layouts.app')

@section('content')
<section class="heroSection">
        <div class="container">
            <h1 class="img-header-text fade_down">{{ $post->title }}</h1>
            <div class="breadcrumb-group fade_up">
                <a href="/">HOME / </a>
                <a href="/blog">BLOG / </a>
                <span>{{ $post->title }}</span>
            </div>
        </div>
    </section>
    <!-- ====================================== About Section Two ===================================== -->
    <section class="blog-section">
        <div class="container">
            <div class="row blog-two-grid-row">
                <div class="col-xxl-8 col-xl-8 col-lg-8">
                    @if($post->image)
                        <img class="single-blog-img1" src="{{ Voyager::image($post->image) }}" alt="{{ $post->title }}" width="911px" height="500px" >
                    @endif
                    <div class="tag-date border-bottom-0">
                        <div class="tag-date-sub">
                            <img class="blog-cal-svg" src="{{ asset('frontend/assets/images/svg/user-circle.svg') }}" alt="user-circle">
                            <p>{{ $post->category ? $post->category->name : 'Uncategorized' }}</p>
                        </div>
                        <div class="tag-date-sub">
                            <img class="blog-cal-svg" src="{{ asset('frontend/assets/images/svg/calendar-week.svg') }}" alt="calendar-week">
                            <p>{{ $post->created_at->format('d M Y') }}</p>
                        </div>
                        {{-- <div class="tag-date-sub">
                            <img src="{{ asset('frontend/assets/images/svg/message-circle.svg') }}" alt="message-circle">
                            <p>{{ $post->created_at->diffForHumans() }}</p>
                        </div> --}}
                    </div>
                    @if($post->excerpt)
                        <p class="fusce fade_down">{{ $post->excerpt }}</p>
                    @endif
                    <div class="blog-content fade_down">
                        {!! $post->body !!}
                    </div>

                </div>
                <div class="col-xxl-4 col-xl-4 col-lg-4 col-md-8">
                    <div class="search-box-main">
                        <form action="{{ route('blog') }}" method="GET">
                            <div class="search-input">
                                <input type="text" placeholder="Search Here..." name="search" value="{{ request('search') }}">
                                <button type="submit" class="search-box">
                                    <img src="{{ asset('frontend/assets/images/svg/search-icon.svg') }}" alt="search-icon">
                                </button>
                            </div>
                        </form>
                    </div>
                    <div class="single-services-black-box" id="recent-post-box">
                        <h3>Recent Posts</h3>
                    </div>
                    @foreach($allPosts->take(5) as $recentPost)
                        @if($recentPost->id != $post->id)
                            <a href="{{ route('blog_detail', $recentPost->slug) }}" class="recent-post-main">
                                @if($recentPost->image)
                                    <img src="{{ Voyager::image($recentPost->image) }}" alt="{{ $recentPost->title }}" width="120px" height="90px" >
                                @else
                                    <img src="{{ asset('frontend/assets/images/blog/default-blog.jpg') }}" alt="{{ $recentPost->title }}" width="100px" height="100px" >
                                @endif
                                <div class="recent-post-text-main">
                                    <p>{{ $recentPost->created_at->format('d M Y') }}</p>
                                    <h2>{{ Str::limit($recentPost->title, 50) }}</h2>
                                </div>
                            </a>
                        @endif
                    @endforeach

                    <!-- Categories Section -->
                    <div class="single-services-black-box" id="categories-box">
                        <h3>Categories</h3>
                    </div>
                    <div class="categories-list">
                        @forelse($categories as $category)
                            <a href="{{ route('blog', ['category' => $category->id]) }}" class="category-link">
                                <div class="category-item">
                                    <h4>{{ $category->name }}</h4>
                                    <span class="post-count">({{ $category->posts()->where('status', 'PUBLISHED')->count() }} posts)</span>
                                </div>
                            </a>
                        @empty
                            <div class="category-item">
                                <p>No categories available</p>
                            </div>
                        @endforelse
                    </div>

                </div>
            </div>
        </div>
    </section>
@stop
