@extends('frontend.layouts.app')

@section('content')
  <!-- ====================================== About Hero Section ===================================== -->
  <section class="heroSection">
        <div class="container">
            <h1 class="img-header-text fade_down">Contact Us</h1>
            <div class="breadcrumb-group fade_up">
                <a href="index-slider.html">HOME / </a>
                <a href="contact.html">Contact Us</a>
            </div>
        </div>
    </section>
    <section class="contact-form-section">
        <div class="container">
            <div class="row form-sec-row">
                <div class="col-xxl-6 col-xl-6 col-lg-5">
                    <p class="cap-text fade_up">Sunil Engineering And Systems</p>
                    <h2 class="sec-text get-toch fade_up">Get In Touch With Us</h2>
                    <p class="sec-sub-text fade_up">We would love to hear from you. Whether you are planning a new project, need expert advice, or require reliable HVAC, MEP, or Firefighting services, our team is ready to help. </p>
                    <p class="call-support-text">Sales manager
                    <a href="tel:9248052227" class="tel-num">9248052227</a></p>
                    <p class="call-support-text">Service Incharge
                    <a href="tel:9246283777" class="tel-num">9246283777</a></p>
                    <div class="adres-main-home fade_up">
                        <div>
                            <p class="call-support-text">Our Address</p>
                            <p class="tel-num addees">Plot no. 57, Venkat sai, 4th floor, kavuri hills, phasae-1, Madhapur, Hyderabad, Telangana-50001 </p>
                        </div>
                        <div>
                            <p class="call-support-text">Our Mail Address</p>
                            <a href="mailto:admin@sesaircon.org" class="tel-num addees">admin@sesaircon.org	</a>
                            <a href="mailto:sales@sesaircon.org" class="tel-num addees">sales@sesaircon.org	</a>
                        </div>

                    </div>
                     <div>
                            <p class="call-support-text">  Business Hours  </p>
                            <p class="tel-num addees"> Monday to Saturday: 9:30 AM to 6:30 PM
                            Sunday: Closed
                            </p>
                        </div>
                </div>
                <div class="col-xxl-6 col-xl-6 col-lg-7">
                    <div class="contac-form-main zoom_in">
                        <!-- Success/Error Messages -->
                        <div id="contact-message" class="alert" style="display: none; margin-bottom: 20px; padding: 15px; border-radius: 10px; font-weight: 500;"></div>

                        <form id="contact-form" action="{{ route('contact.submit') }}" method="POST">
                            @csrf
                            <div class="calcult-from-grid contac-form">
                                <div>
                                    <h3 class="input-label-text">Full Name*</h3>
                                    <input type="text" placeholder="Enter your full name" name="name"
                                        autocomplete="off" value="{{ old('name') }}" required>
                                    @error('name')
                                        <div class="text-danger small mt-1">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div>
                                    <h3 class="input-label-text">email address*</h3>
                                    <input type="email" placeholder="Enter your email" name="email"
                                        autocomplete="off" value="{{ old('email') }}" required>
                                    @error('email')
                                        <div class="text-danger small mt-1">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div>
                                    <h3 class="input-label-text">phone number*</h3>
                                    <input type="text" placeholder="Enter phone number" name="mobile"
                                        autocomplete="off" value="{{ old('mobile') }}" required>
                                    @error('mobile')
                                        <div class="text-danger small mt-1">{{ $message }}</div>
                                    @enderror
                                </div>
                            {{-- <div>
                                <h3 class="input-label-text">choose cleaning area*</h3>
                                <div class="input-main">
                                    <div class="wrapper">
                                        <div class="formDropDown">Choose from list
                                            <img class="arrow-icon-form" src="assets/images/svg/dropdown-arrow.svg"
                                                alt="arrow-icon-form">
                                        </div>
                                        <div class="position-relative">
                                            <ul class="formDropDown-ul-list">
                                                <li><a href="javascript:void(0)">Full Cleaning</a></li>
                                                <li><a href="javascript:void(0)">House Cleaning</a></li>
                                                <li><a href="javascript:void(0)">Kitchen Cleaning</a></li>
                                                <li><a href="javascript:void(0)">Office Cleaning</a></li>
                                                <li><a href="javascript:void(0)">Window Cleaning</a></li>
                                                <li><a href="javascript:void(0)">Corporate Cleaning</a></li>
                                                <li><a href="javascript:void(0)">Carpet Cleaning</a></li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div> --}}
                        </div>
                            {{-- </div> --}}
                            <div class="your-message-input">
                                <h3 class="input-label-text">your Subject</h3>
                                <input type="text" placeholder="subject " name="subject"
                                    autocomplete="off" value="{{ old('subject') }}" required>
                                @error('subject')
                                    <div class="text-danger small mt-1">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="your-message-input">
                                <h3 class="input-label-text">your message</h3>
                                <textarea placeholder="Write here" name="message" rows="4"
                                    autocomplete="off" required style="border-radius: 10px; border: 2px solid #F5F6F7; background: #FFF; padding: 12px 15px; width: 100%; color: #000; font-size: 18px; font-weight: 400; line-height: 24px; resize: vertical;">{{ old('message') }}</textarea>
                                @error('message')
                                    <div class="text-danger small mt-1">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="get-cost-estimate send-main-btn">
                                <button type="submit" class="btn-quote" id="submit-btn">
                                    <span id="btn-text">Send Us Your Mail</span>
                                    <span id="btn-loading" style="display: none;">Sending...</span>
                                    <img src="/frontend/assets/images/svg/cross-arrow.svg" alt="cross-arrow">
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
            {{-- <iframe class="map-iframe"
                src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d11661.278162829134!2d-76.16113884753138!3d43.0557465765357!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x89d9f3add89232d3%3A0x516c4febad79a023!2sNear%20Northeast%2C%20Syracuse%2C%20NY%2013203%2C%20USA!5e0!3m2!1sen!2sin!4v1704092010021!5m2!1sen!2sin"
                allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade">
            </iframe> --}}
            <iframe  class="map-iframe"
            src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3806.3745958325426!2d78.398802!3d17.441776!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x3bcb973f0b0373c7%3A0xdefddee7880a2508!2sSunil%20Engineering%20And%20Systems!5e0!3m2!1sen!2sin!4v1756456717797!5m2!1sen!2sin" width="600" height="450" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
        </div>
    </section>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const form = document.getElementById('contact-form');
            const messageDiv = document.getElementById('contact-message');
            const submitBtn = document.getElementById('submit-btn');
            const btnText = document.getElementById('btn-text');
            const btnLoading = document.getElementById('btn-loading');

            form.addEventListener('submit', function(e) {
                e.preventDefault();

                // Show loading state
                submitBtn.disabled = true;
                btnText.style.display = 'none';
                btnLoading.style.display = 'inline';

                // Hide previous messages
                messageDiv.style.display = 'none';

                // Clear previous validation errors
                const errorDivs = form.querySelectorAll('.text-danger');
                errorDivs.forEach(div => div.remove());

                // Prepare form data
                const formData = new FormData(form);

                // Submit form via AJAX
                fetch(form.action, {
                    method: 'POST',
                    body: formData,
                    headers: {
                        'X-Requested-With': 'XMLHttpRequest'
                    }
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        // Show success message
                        messageDiv.className = 'alert';
                        messageDiv.style.backgroundColor = '#d4edda';
                        messageDiv.style.color = '#155724';
                        messageDiv.style.border = '1px solid #c3e6cb';
                        messageDiv.textContent = data.message;
                        messageDiv.style.display = 'block';

                        // Reset form
                        form.reset();

                        // Scroll to message
                        messageDiv.scrollIntoView({ behavior: 'smooth' });
                    } else {
                        // Show error message
                        messageDiv.className = 'alert';
                        messageDiv.style.backgroundColor = '#f8d7da';
                        messageDiv.style.color = '#721c24';
                        messageDiv.style.border = '1px solid #f5c6cb';
                        messageDiv.textContent = data.message || 'An error occurred. Please try again.';
                        messageDiv.style.display = 'block';
                    }
                })
                .catch(error => {
                    console.error('Error:', error);
                    messageDiv.className = 'alert';
                    messageDiv.style.backgroundColor = '#f8d7da';
                    messageDiv.style.color = '#721c24';
                    messageDiv.style.border = '1px solid #f5c6cb';
                    messageDiv.textContent = 'An error occurred. Please try again.';
                    messageDiv.style.display = 'block';
                })
                .finally(() => {
                    // Reset button state
                    submitBtn.disabled = false;
                    btnText.style.display = 'inline';
                    btnLoading.style.display = 'none';
                });
            });
        });
    </script>
@stop
