<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sunil Engineering And Systems</title>
    <link rel="icon" type="image/x-icon" href="/frontend/assets/images/svg/favicon.svg">
    <link rel="stylesheet" href="/frontend/assets/css/swap.css">
    <link rel="stylesheet" href="/frontend/assets/css/bootstrap.min.css">
    <link rel="stylesheet" href="/frontend/assets/css/swiper.min.css">
    <link rel="stylesheet" href="/frontend/assets/css/style.css">
    <link rel="stylesheet" href="/frontend/assets/css/media_query.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
</head>

<body>
    <!-- ====================================== Preloader ===================================== -->
    <div class="page-loader">
        <div class="leap-frog">
            <div class="leap-frog__dot"></div>
            <div class="leap-frog__dot"></div>
            <div class="leap-frog__dot"></div>
        </div>
    </div>
    <!-- ====================================== Header ===================================== -->
    <div class="overlay" id="overlay"></div>
    <header class="header" id="top-navbar">
        <div class="header-container">
            <a href="index-slider.html" class="logo">
                <img src="/frontend/assets/images/svg/logoses.png" alt="Logo" width="150px">
            </a>
            <div class="hamburger" id="hamburger">
                <img src="/frontend/assets/images/svg/menu2.svg" class="menu-icon" alt="menu2">
                <img src="/frontend/assets/images/svg/close-icon.svg" alt="close-icon" class="close-icon">
            </div>
            <nav class="nav" id="main-menu">
                <img class="dsad" src="/frontend/assets/images/home/dsad.png" alt="dsad">
                <div class="for-mobile-menu position-relative">
                    <a href="index-slider.html" class="mobile-logo">
                        <img src="/frontend/assets/images/svg/logoses.png" alt="Logo" width="200px" height="110px" >
                    </a>
                    <ul class="menu">
                        <li><a href="/">Home</a></li>
                        <li><a href="/about">About</a></li>
                        <li><a href="/service">Services</a></li>
                        <li><a href="/sales">Sales</a></li>
                        <li><a href="/clients">Clients</a></li>
                        <li><a href="/career">Career</a></li>
                        <li><a href="/blog">Blog</a></li>
                        <li><a href="/contactus">Contact</a></li>

                    </ul>
                </div>
                <div class="nav-actions">
                    <div class="call">
                        <div class="headphone-main">
                            <img src="/frontend/assets/images/svg/headphone-icon.svg" alt="headphone-icon">
                        </div>
                        <div class="need-help-main">
                            <p>Need Help Now?</p>
                            <a href="tel:+12483578866"> 9246283777</a>
                        </div>
                    </div>
                    <a href="/contactus" class="btn-quote get-quote-btn">Get A Quote
                        <img src="/frontend/assets/images/svg/cross-arrow.svg" alt="cross-arrow">
                    </a>
                </div>
            </nav>
        </div>
    </header>
   @yield('content')
    <!-- ====================================== Footer Section ===================================== -->
    <footer>
        <div class="container">
            <div class="subscribe-section">
                <h2 class="sec-text updat">Complete HVAC, MEP, and Firefighting solutions designed for comfort, efficiency, and protection.</h2>
                {{-- <div class="subscribe-input-main">
                    <input type="text" placeholder="Enter phone number" name="subscribe">
                    <a href="#" class="btn-quote">Subscribe Now
                        <img src="/frontend/assets/images/svg/cross-arrow.svg" alt="cross-arrow">
                    </a>
                </div> --}}
            </div>
            <div class="row footer-row-quick">
                <div class="col-xxl-3 col-xl-3 col-lg-4 col-md-6">
                    <h2 class="working-hours">Working Hours</h2>
                    <div class="timing-hrw pt-0">
                        <p>Mon to Sat </p>

                        <p>9:30 AM to 6:30 PM  </p>
                    </div>
                    <div class="timing-hrw">
                        <p>Sunday</p>
                        <p >Closed</p>
                    </div>
                </div>
                <div class="col-xxl-4 col-xl-4 col-lg-4 col-md-6 quicklinks-main">
                    <div>
                        <h2 class="working-hours">Our Services</h2>
                        <ul>
                            @forelse($services ?? [] as $service)
                                <li><a href="{{ route('service_detail', $service->slug) }}">{{ $service->title }}</a></li>
                            @empty
                                <li><a href="{{ route('service') }}">View All Services</a></li>
                            @endforelse
                        </ul>
                    </div>
                    <div>
                        <h2 class="working-hours">Special Sales</h2>
                        <ul>
                            @forelse($sales ?? [] as $sale)
                                <li><a href="{{ route('sales_detail', $sale->slug) }}">{{ $sale->title }}</a></li>
                            @empty
                                <li><a href="{{ route('sales') }}">View All Sales</a></li>
                            @endforelse
                        </ul>
                    </div>
                </div>
                <div class="col-xxl-4 col-xl-4 col-lg-4">
                    <div class="footer-contact-details">
                        <h2 class="working-hours">Contact Details</h2>
                        <div class="footer-contact-item">
                            <h4 class="contact-label">Our Address</h4>
                            <p class="contact-info">Plot no. 57, Venkat sai, 4th floor, kavuri hills, phase-1, Madhapur, Hyderabad, Telangana-500081</p>
                        </div>
                        <div class="footer-contact-item">
                            <h4 class="contact-label">Phone Numbers</h4>
                            <p class="contact-info">
                                <a href="tel:9248052227" class="footer-phone">9248052227</a><br>
                                <a href="tel:9246283777" class="footer-phone">9246283777</a>
                            </p>
                        </div>
                        <div class="footer-contact-item">
                            <h4 class="contact-label">Email Address</h4>
                            <p class="contact-info">
                                <a href="mailto:admin@sesaircon.org" class="footer-email">admin@sesaircon.org</a><br>
                                <a href="mailto:sales@sesaircon.org" class="footer-email">sales@sesaircon.org</a>
                            </p>
                        </div>
                    </div>
                </div>

            </div>
            <div class="media-logo-call-footer fade_up show">
                <a href="index-slider.html">
                    <img src="/frontend/assets/images/svg/logoses.png"  width="200px" height="110px" alt="white-logo">
                </a>
                <div class="call-detl">
                    <div class="img-main-call">
                        <img src="/frontend/assets/images/svg/callWhite.svg" alt="callWhite">
                    </div>
                    <div>
                        <p>CALL US NOW!</p>
                        <a href="tel:9248052227">9248052227</a>
                    </div>
                </div>
                <div class="footer-med-icons-main">
                    <a href="https://www.facebook.com" class="footer-med-icons">
                        <img src="/frontend/assets/images/svg/facebook.svg" alt="facebook">
                    </a>
                    <a href="https://x.com" class="footer-med-icons">
                        <img src="/frontend/assets/images/svg/twitter.svg" alt="twiiter">
                    </a>
                    <a href="https://www.instagram.com" class="footer-med-icons">
                        <img src="/frontend/assets/images/svg/insta.svg" alt="insta">
                    </a>
                    <a href="https://wa.me/+1234567890" class="footer-med-icons">
                        <img src="/frontend/assets/images/svg/whatsapp.svg" alt="whatsapp">
                    </a>
                </div>
            </div>
            <div class="copyrights-main">
                <p>Copyright © {{ date('Y') }}  All Rights Reserved by <a href="#"
                        target="_blank">Sunil Engineering and Systems</a>
                </p>
                <p><a href="/privacy">Privacy Policy</a> | <a href="/tandc">Terms &amp; Conditions</a></p>
            </div>
        </div>
    </footer>
    <!-- ====================== Bottom To Top Button ======================= -->
    <button class="bottom-top-button">↑</button>
    <script src="/frontend/assets/javascript/jquery.js"></script>
    <script src="/frontend/assets/javascript/bootstrap.min.js"></script>
    <script src="/frontend/assets/javascript/swiper-bundle.min.js"></script>
    <script src="/frontend/assets/javascript/smooth-scroll.js"></script>
    <script src="/frontend/assets/javascript/gsap.js"></script>
    <script src="/frontend/assets/javascript/scrollMagic.min.js"></script>
    <script src="/frontend/assets/javascript/animation.gsap.min.js"></script>
    <script src="/frontend/assets/javascript/script.js"></script>

    <style>
        /* Footer Contact Details Styling */
        .footer-contact-details {
            color: white;
        }

        .footer-contact-details .working-hours {
            margin-bottom: 20px;
        }

        .footer-contact-item {
            margin-bottom: 15px;
        }

        .contact-label {
            color: #fff;
            font-size: 14px;
            font-weight: 600;
            margin-bottom: 5px;
            text-transform: uppercase;
        }

        .contact-info {
            color: #000;
            font-size: 14px;
            line-height: 1.6;
            margin: 0;
        }

        .footer-phone, .footer-email {
            color: #000;
            text-decoration: none;
            transition: color 0.3s ease;
        }

        .footer-phone:hover, .footer-email:hover {
            color: #000;
        }

        /* Categories Section Styling */
        .categories-list {
            margin-bottom: 30px;
        }

        .category-link {
            text-decoration: none;
            color: inherit;
            display: block;
            margin-bottom: 10px;
        }

        .category-item {
            padding: 12px 15px;
            background: #f8f9fa;
            border-radius: 8px;
            border-left: 3px solid #007bff;
            transition: all 0.3s ease;
        }

        .category-item:hover {
            background: #e9ecef;
            transform: translateX(5px);
        }

        .category-item h4 {
            margin: 0 0 5px 0;
            font-size: 16px;
            font-weight: 600;
            color: #333;
        }

        .post-count {
            font-size: 12px;
            color: #666;
            font-weight: 500;
        }

        .category-link:hover .category-item h4 {
            color: #007bff;
        }

        /* Career Cards Styling */
        .career-card {
            border: 1px solid #e0e0e0;
            border-radius: 15px;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
            transition: all 0.3s ease;
            background: #fff;
            overflow: hidden;
            height: 100%;
            display: flex;
            flex-direction: column;
        }

        .career-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 8px 25px rgba(0, 0, 0, 0.15);
            border-color: #007bff;
        }

        .career-header {
            background: linear-gradient(135deg, #007bff 0%, #0056b3 100%);
            color: white;
            padding: 20px;
            text-align: center;
        }

        .career-title {
            font-size: 18px;
            font-weight: 600;
            margin: 0 0 10px 0;
            color: white !important;
        }

        .career-location {
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 5px;
            font-size: 14px;
            opacity: 0.9;
        }

        .career-location i {
            font-size: 12px;
        }

        .career-details {
            padding: 20px;
            background: #f8f9fa;
            margin: 15px;
            border-radius: 10px;
            border-left: 4px solid #007bff;
        }

        .career-info {
            margin-bottom: 8px;
            font-size: 14px;
            color: #555;
        }

        .career-info strong {
            color: #333;
            font-weight: 600;
        }

        .career-card .card-containe {
            flex-grow: 1;
            display: flex;
            flex-direction: column;
            padding: 0 20px;
        }

        .career-card .services-card-sub-text {
            margin: 15px 0;
            color: #666;
            line-height: 1.6;
            flex-grow: 1;
        }

        .career-card .card-learn-more {
            margin: 20px;
            padding: 12px 20px;
            background: linear-gradient(135deg, #007bff 0%, #0056b3 100%);
            color: white;
            text-decoration: none;
            border-radius: 8px;
            text-align: center;
            font-weight: 600;
            transition: all 0.3s ease;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 8px;
        }

        .career-card .card-learn-more:hover {
            /* background: linear-gradient(135deg, #0056b3 0%, #004085 100%);
            transform: translateY(-2px);
            color: white; */
        }

        .career-card .services-svg-main {
            display: none; /* Hide the icon as we have a better header design */
        }

        /* Blog Image Sizing */
        .blog-img {
            width: 410px !important;
            height: 300px !important;
            object-fit: cover;
            border-radius: 8px;
        }

        .blog-img-main {
            width: 410px;
            height: 300px;
            overflow: hidden;
            border-radius: 8px;
            position: relative;
        }

        /* Blog Detail Page Main Image */
        .blog-detail-img {
            width: 100% !important;
            max-width: 410px;
            height: 300px !important;
            object-fit: cover;
            border-radius: 8px;
        }

        /* Recent Posts Images */
        .recent-post-main img {
            width: 100px !important;
            height: 75px !important;
            object-fit: cover;
            border-radius: 6px;
        }

        /* Clients Page Images - 170x170 */
        .client-img, .portfolio-img {
            width: 170px !important;
            height: 170px !important;
            object-fit: cover;
            border-radius: 8px;
        }

        .client-img-container, .portfolio-img-container {
            width: 170px;
            height: 170px;
            overflow: hidden;
            border-radius: 8px;
            margin: 0 auto;
        }

        /* Services Page Images - 410x280 */
        .services-card-img, .service-img {
            width: 410px !important;
            height: 280px !important;
            object-fit: cover;
            border-radius: 8px;
        }

        .services-card-img-main {
            width: 410px;
            height: 280px;
            overflow: hidden;
            border-radius: 8px;
            position: relative;
        }

        /* Sales Page Images - 410x280 */
        .sales-card-img, .sale-img {
            width: 410px !important;
            height: 280px !important;
            object-fit: cover;
            border-radius: 8px;
        }

        .sales-card-img-main {
            width: 410px;
            height: 280px;
            overflow: hidden;
            border-radius: 8px;
            position: relative;
        }

        /* Index Page Services Section Images - 410x280 */
        .cleaning-card-img, .service-card-img {
            width: 410px !important;
            height: 280px !important;
            object-fit: cover;
            border-radius: 8px;
        }

        .cleaning-card-img-main {
            width: 410px;
           /* height: 280px; */
            overflow: hidden;
            border-radius: 8px;
            position: relative;
        }

        /* Index Page Sales Section Images - 410x280 */
        .sales-slider-img {
            width: 410px !important;
            height: 280px !important;
            object-fit: cover;
            border-radius: 8px;
        }
    </style>
    <script>
        /*--------------Img Scrolling------------------*/
        var controller = new ScrollMagic.Controller();
        var slides = $('.image');
        for (var i = 0; i < slides.length; i++) {
            var image = $('img', slides[i]);
            var tween = TweenMax.to(image, 1, { scale: 1.6, ease: Power0.easeNone });
            var scene = new ScrollMagic
                .Scene({
                    triggerElement: slides[i],
                    duration: "150%",
                    triggerHook: 'onEnter'
                })
                .setTween(tween)
                .addTo(controller);
        }
    </script>
</body>

</html>
