@extends('frontend.layouts.app')

@section('content')
    <!-- ====================================== Privacy Policy Hero Section ===================================== -->
    <section class="heroSection">
        <div class="container">
            <h1 class="img-header-text fade_down">Privacy Policy</h1>
            <div class="breadcrumb-group fade_up">
                <a href="/">HOME / </a>
                <a href="/privacy">Privacy Policy</a>
            </div>
        </div>
    </section>

    <!-- ====================================== Privacy Policy Content ===================================== -->
    <section class="privacy-policy-section">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-xxl-10 col-xl-10 col-lg-12">
                    <div class="privacy-content">
                        <div class="policy-header">
                            <h2>Privacy Policy for Sunil Engineering and Systems</h2>
                            <p class="last-updated">Last updated: {{ date('F d, Y') }}</p>
                        </div>

                        <div class="policy-section">
                            <h3>1. Information We Collect</h3>
                            <p>At Sunil Engineering and Systems, we collect information you provide directly to us, such as when you:</p>
                            <ul>
                                <li>Fill out contact forms or request quotes</li>
                                <li>Subscribe to our newsletter</li>
                                <li>Apply for job positions</li>
                                <li>Contact us via phone or email</li>
                                <li>Use our website and services</li>
                            </ul>
                            <p>The types of information we may collect include your name, email address, phone number, company name, project details, and any other information you choose to provide.</p>
                        </div>

                        <div class="policy-section">
                            <h3>2. How We Use Your Information</h3>
                            <p>We use the information we collect to:</p>
                            <ul>
                                <li>Provide, maintain, and improve our HVAC, MEP, and firefighting services</li>
                                <li>Process and respond to your inquiries and service requests</li>
                                <li>Send you technical notices, updates, and administrative messages</li>
                                <li>Communicate with you about projects, services, and promotional offers</li>
                                <li>Process job applications and recruitment activities</li>
                                <li>Comply with legal obligations and protect our rights</li>
                            </ul>
                        </div>

                        <div class="policy-section">
                            <h3>3. Information Sharing and Disclosure</h3>
                            <p>We do not sell, trade, or otherwise transfer your personal information to third parties without your consent, except in the following circumstances:</p>
                            <ul>
                                <li><strong>Service Providers:</strong> We may share information with trusted third-party service providers who assist us in operating our website and conducting our business</li>
                                <li><strong>Legal Requirements:</strong> We may disclose information when required by law or to protect our rights and safety</li>
                                <li><strong>Business Transfers:</strong> Information may be transferred in connection with a merger, acquisition, or sale of assets</li>
                            </ul>
                        </div>

                        <div class="policy-section">
                            <h3>4. Data Security</h3>
                            <p>We implement appropriate technical and organizational security measures to protect your personal information against unauthorized access, alteration, disclosure, or destruction. However, no method of transmission over the internet or electronic storage is 100% secure.</p>
                        </div>

                        <div class="policy-section">
                            <h3>5. Contact Information</h3>
                            <p>If you have any questions about this Privacy Policy, please contact us:</p>
                            <div class="contact-info">
                                <p><strong>Sunil Engineering and Systems</strong></p>
                                <p>Plot no. 57, Venkat sai, 4th floor, kavuri hills, phase-1, Madhapur, Hyderabad, Telangana-500081</p>
                                <p>Phone: <a href="tel:9248052227">9248052227</a> | <a href="tel:9246283777">9246283777</a></p>
                                <p>Email: <a href="mailto:admin@sesaircon.org">admin@sesaircon.org</a></p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

<style>
/* Privacy Policy Styling */
.privacy-policy-section {
    padding: 60px 0;
    background: #f8f9fa;
}

.privacy-content {
    background: white;
    padding: 40px;
    border-radius: 15px;
    box-shadow: 0 5px 20px rgba(0, 0, 0, 0.1);
}

.policy-header {
    text-align: center;
    margin-bottom: 40px;
    padding-bottom: 20px;
    border-bottom: 2px solid #007bff;
}

.policy-header h2 {
    color: #333;
    font-size: 28px;
    font-weight: 700;
    margin-bottom: 10px;
}

.last-updated {
    color: #666;
    font-style: italic;
    margin: 0;
}

.policy-section {
    margin-bottom: 35px;
    padding: 25px;
    background: #f8f9fa;
    border-radius: 10px;
    border-left: 4px solid #007bff;
}

.policy-section h3 {
    color: #007bff;
    font-size: 20px;
    font-weight: 600;
    margin-bottom: 15px;
}

.policy-section p {
    color: #555;
    line-height: 1.7;
    margin-bottom: 15px;
}

.policy-section ul {
    margin: 15px 0;
    padding-left: 20px;
}

.policy-section li {
    color: #555;
    line-height: 1.6;
    margin-bottom: 8px;
}

.contact-info {
    background: white;
    padding: 20px;
    border-radius: 8px;
    border: 1px solid #e0e0e0;
    margin-top: 15px;
}

.contact-info p {
    margin-bottom: 8px;
}

.contact-info a {
    color: #007bff;
    text-decoration: none;
}

.contact-info a:hover {
    text-decoration: underline;
}

@media (max-width: 768px) {
    .privacy-content {
        padding: 25px;
    }

    .policy-header h2 {
        font-size: 24px;
    }

    .policy-section {
        padding: 20px;
    }
}
</style>
@stop
