@extends('frontend.layouts.app')

@section('content')
<section class="heroSection">
        <div class="container">
            <h1 class="img-header-text fade_down">{{$sale->title}}  </h1>
            <div class="breadcrumb-group fade_up">
                <a href="/">HOME / </a>
                <a href="/sales">Sales / </a>
                <a href="/sales_detail/{{ $sale->slug }}">{{ $sale->title }}</a>
            </div>
        </div>
    </section>
    <!-- ====================================== Section Nine ===================================== -->
    <section class="section-eight">
        <div class="container">
            <div class="row all-services-row">
                <div class="col-xxl-8 col-xl-8 col-lg-8 col-md-12">
                    {{-- <h2 class="sec-text pb-0 fade_up">{{$sale->short_desc}} </h2> --}}
                    <img class="layers-img1 zoom_in" src="{{ asset('storage/' . $sale->img) }}"
                        alt="house-clening-img1">
                             {{-- <img src="{{ asset('storage/' . $sale->img) }}" alt="{{ $sale->title }}"> --}}

                    <p class="fusce pb-2"> {{$sale->short_desc}}<br> {!! $sale->long_desc !!}</p>


                </div>
                <div class="col-xxl-4 col-xl-4 col-lg-4 col-md-8 all-service-col">
                    <div class="services-list-box zoom_in">
                        <h2 class="all-service-text">Our All Service</h2>
                        <div class="roofing-services-list-main">
                            @forelse($allSales as $saleItem)
                            <a href="/sales_detail/{{ $saleItem->slug }}"
                               class="service-list-arow-main {{ $saleItem->slug === $sale->slug ? 'active' : '' }} {{ $loop->last ? 'mb-0' : '' }}">
                                <p>{{ $saleItem->title }}</p>
                                <img src="/frontend/assets/images/svg/cross-arrow.svg" alt="right-arrow">
                            </a>
                            @empty
                            <div class="service-list-arow-main">
                                <p>No sale available</p>
                            </div>
                            @endforelse
                        </div>
                    </div>

                    <!-- Enquiry Form -->
                    <div class="services-list-box zoom_in" style="margin-top: 30px;">
                        <h2 class="all-service-text">Enquire About This Sale</h2>
                        <form id="sales-enquiry-form" action="{{ route('sales.enquiry.submit') }}" method="POST">
                            @csrf
    <!-- SweetAlert2 CDN -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <script>
    document.addEventListener('DOMContentLoaded', function() {
        const form = document.getElementById('sales-enquiry-form');
        const submitBtn = document.getElementById('sales-enq-submit-btn');
        const btnText = document.getElementById('sales-enq-btn-text');
        const btnLoading = document.getElementById('sales-enq-btn-loading');

        if (form) {
            form.addEventListener('submit', function(e) {
                e.preventDefault();

                // Show loading state
                submitBtn.disabled = true;
                btnText.style.display = 'none';
                btnLoading.style.display = 'inline';

                const formData = new FormData(form);

                fetch(form.action, {
                    method: 'POST',
                    body: formData,
                    headers: { 'X-Requested-With': 'XMLHttpRequest' }
                })
                .then(async (response) => {
                    const data = await response.json();
                    if (!response.ok) {
                        throw data;
                    }
                    return data;
                })
                .then(data => {
                    if (data.success) {
                        Swal.fire({
                            title: 'Success!',
                            text: data.message,
                            icon: 'success',
                            confirmButtonText: 'OK',
                            confirmButtonColor: '#3c55ab'
                        }).then(() => {
                            form.reset();
                        });
                    } else {
                        Swal.fire({
                            title: 'Error!',
                            text: data.message || 'An error occurred. Please try again.',
                            icon: 'error',
                            confirmButtonText: 'OK',
                            confirmButtonColor: '#3c55ab'
                        });
                    }
                })
                .catch(err => {
                    const message = (err && err.message) ? err.message : 'An error occurred. Please check your inputs and try again.';
                    Swal.fire({
                        title: 'Error!',
                        text: message,
                        icon: 'error',
                        confirmButtonText: 'OK',
                        confirmButtonColor: '#3c55ab'
                    });
                })
                .finally(() => {
                    submitBtn.disabled = false;
                    btnText.style.display = 'inline';
                    btnLoading.style.display = 'none';
                });
            });
        }
    });
    </script>

                            <input type="hidden" name="sales_id" value="{{ $sale->id }}">

                            <div class="form-group mb-3">
                                <label for="sales-enq-name" class="form-label">Full Name *</label>
                                <input type="text" class="form-control" id="sales-enq-name" name="name" required>
                            </div>

                            <div class="form-group mb-3">
                                <label for="sales-enq-email" class="form-label">Email Address *</label>
                                <input type="email" class="form-control" id="sales-enq-email" name="email" required>
                            </div>

                            <div class="form-group mb-3">
                                <label for="sales-enq-mobile" class="form-label">Mobile *</label>
                                <input type="text" class="form-control" id="sales-enq-mobile" name="mobile" required>
                            </div>

                            <div class="form-group mb-3">
                                <label for="sales-enq-desc" class="form-label">Message</label>
                                <textarea class="form-control" id="sales-enq-desc" name="desc" rows="4" placeholder="Tell us more about your enquiry"></textarea>
                            </div>

                            <button type="submit" class="btn-quote w-100" id="sales-enq-submit-btn">
                                <span id="sales-enq-btn-text">Submit Enquiry</span>
                                <span id="sales-enq-btn-loading" style="display: none;">Submitting...</span>
                                <img src="/frontend/assets/images/svg/cross-arrow.svg" alt="cross-arrow">
                            </button>
                        </form>
                    </div>



                </div>
            </div>
        </div>
    </section>
    <!-- ====================================== Section Form ===================================== -->

@stop
