@extends('frontend.layouts.app')

@section('content')
<section class="heroSection">
        <div class="container">
            <h1 class="img-header-text fade_down">{{$service->title}}  </h1>
            <div class="breadcrumb-group fade_up">
                <a href="/">HOME / </a>
                <a href="/service">Service / </a>
                <a href="/service_detail/{{ $service->slug }}">{{ $service->title }}</a>
            </div>
        </div>
    </section>
    <!-- ====================================== Section Nine ===================================== -->
    <section class="section-eight">
        <div class="container">
            <div class="row all-services-row">
                <div class="col-xxl-8 col-xl-8 col-lg-8 col-md-12">
                    {{-- <h2 class="sec-text pb-0 fade_up">{{$service->short_desc}} </h2> --}}
                    <img class="layers-img1 zoom_in" src="{{ asset('storage/' . $service->img) }}"
                        alt="house-clening-img1">
                             {{-- <img src="{{ asset('storage/' . $service->img) }}" alt="{{ $service->title }}"> --}}

                    <p class="fusce pb-2"> {{$service->short_desc}} <br> {!! $service->long_desc !!}</p>


                </div>
                <div class="col-xxl-4 col-xl-4 col-lg-4 col-md-8 all-service-col">
                    <div class="services-list-box zoom_in">
                        <h2 class="all-service-text">Our All Service</h2>
                        <div class="roofing-services-list-main">
                            @forelse($allServices as $serviceItem)
                            <a href="/service_detail/{{ $serviceItem->slug }}"
                               class="service-list-arow-main {{ $serviceItem->slug === $service->slug ? 'active' : '' }} {{ $loop->last ? 'mb-0' : '' }}">
                                <p>{{ $serviceItem->title }}</p>
                                <img src="/frontend/assets/images/svg/cross-arrow.svg" alt="right-arrow">
                            </a>
                            @empty
                            <div class="service-list-arow-main">
                                <p>No services available</p>
                            </div>
                            @endforelse
                        </div>
                    </div>

                    <!-- Enquiry Form -->
                    <div class="services-list-box zoom_in" style="margin-top: 30px;">
                        <h2 class="all-service-text">Enquire About This Service</h2>
                        <form id="service-enquiry-form" action="{{ route('service.enquiry.submit') }}" method="POST">
                            @csrf

                            <input type="hidden" name="service_id" value="{{ $service->id }}">

                            <div class="form-group mb-3">
                                <label for="enq-name" class="form-label">Full Name *</label>
                                <input type="text" class="form-control" id="enq-name" name="name" required>
                            </div>

                            <div class="form-group mb-3">
                                <label for="enq-email" class="form-label">Email Address *</label>
                                <input type="email" class="form-control" id="enq-email" name="email" required>
                            </div>

                            <div class="form-group mb-3">
                                <label for="enq-mobile" class="form-label">Mobile *</label>
                                <input type="text" class="form-control" id="enq-mobile" name="mobile" required>
                            </div>

                            <div class="form-group mb-3">
                                <label for="enq-desc" class="form-label">Message</label>
                                <textarea class="form-control" id="enq-desc" name="desc" rows="4" placeholder="Tell us more about your enquiry"></textarea>
                            </div>

                            <button type="submit" class="btn-quote w-100" id="enq-submit-btn">
                                <span id="enq-btn-text">Submit Enquiry</span>
                                <span id="enq-btn-loading" style="display: none;">Submitting...</span>
                                <img src="/frontend/assets/images/svg/cross-arrow.svg" alt="cross-arrow">
                            </button>
                        </form>
                    </div>



                </div>
            </div>
        </div>
    </section>
    <!-- ====================================== Section Form ===================================== -->

    <!-- SweetAlert2 CDN -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <script>
    document.addEventListener('DOMContentLoaded', function() {
        const form = document.getElementById('service-enquiry-form');
        const submitBtn = document.getElementById('enq-submit-btn');
        const btnText = document.getElementById('enq-btn-text');
        const btnLoading = document.getElementById('enq-btn-loading');

        if (form) {
            form.addEventListener('submit', function(e) {
                e.preventDefault();

                // Show loading state
                submitBtn.disabled = true;
                btnText.style.display = 'none';
                btnLoading.style.display = 'inline';

                const formData = new FormData(form);

                fetch(form.action, {
                    method: 'POST',
                    body: formData,
                    headers: { 'X-Requested-With': 'XMLHttpRequest' }
                })
                .then(async (response) => {
                    const data = await response.json();
                    if (!response.ok) {
                        throw data;
                    }
                    return data;
                })
                .then(data => {
                    if (data.success) {
                        Swal.fire({
                            title: 'Success!',
                            text: data.message,
                            icon: 'success',
                            confirmButtonText: 'OK',
                            confirmButtonColor: '#3c55ab'
                        }).then(() => {
                            form.reset();
                        });
                    } else {
                        Swal.fire({
                            title: 'Error!',
                            text: data.message || 'An error occurred. Please try again.',
                            icon: 'error',
                            confirmButtonText: 'OK',
                            confirmButtonColor: '#3c55ab'
                        });
                    }
                })
                .catch(err => {
                    const message = (err && err.message) ? err.message : 'An error occurred. Please check your inputs and try again.';
                    Swal.fire({
                        title: 'Error!',
                        text: message,
                        icon: 'error',
                        confirmButtonText: 'OK',
                        confirmButtonColor: '#3c55ab'
                    });
                })
                .finally(() => {
                    submitBtn.disabled = false;
                    btnText.style.display = 'inline';
                    btnLoading.style.display = 'none';
                });
            });
        }
    });
    </script>

@stop
