<?php

use App\Http\Controllers\FrontendController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/', [FrontendController::class, 'index']);
Route::get('/about', [FrontendController::class, 'about']);
Route::get('/contactus', [FrontendController::class, 'contactus']);
Route::get('/privacy', [FrontendController::class, 'privacy']);
Route::get('/tandc', [FrontendController::class, 'tandc']);
Route::get('/blog', [FrontendController::class, 'blog']);
Route::get('/blog_detail/{slug}', [FrontendController::class, 'blog_detail'])->name('blog_detail');
Route::get('/service', [FrontendController::class, 'service']);
Route::get('/service_detail/{slug}', [FrontendController::class, 'service_detail'])->name('service_detail');
Route::get('/sales', [FrontendController::class, 'sales']);
Route::get('/sales_detail/{slug}', [FrontendController::class, 'sales_detail'])->name('sales_detail');
Route::get('/clients', [FrontendController::class, 'clients']);
Route::get('/career', [FrontendController::class, 'career'])->name('career');
Route::get('/career_detail/{slug}', [FrontendController::class, 'career_detail'])->name('career_detail');
Route::post('/career-application-submit', [FrontendController::class, 'careerApplicationSubmit'])->name('career.application.submit');
Route::get('/blog', [FrontendController::class, 'blog'])->name('blog');

// Contact form submission routes
Route::post('/contact-form-submit', [FrontendController::class, 'contactFormSubmit'])->name('contact.submit');

// Service enquiry submission route
Route::post('/service-enquiry-submit', [FrontendController::class, 'serviceEnquirySubmit'])->name('service.enquiry.submit');
// Sales enquiry submission route
Route::post('/sales-enquiry-submit', [FrontendController::class, 'salesEnquirySubmit'])->name('sales.enquiry.submit');


Route::group(['prefix' => 'admin'], function () {
    Voyager::routes();
});
