<?php $__env->startSection('content'); ?>
<section class="heroSection">
    <div class="container">
        <h1 class="img-header-text fade_down"><?php echo e($career->job_title); ?></h1>
        <div class="breadcrumb-group fade_up">
            <a href="/">HOME / </a>
            <a href="/career">Career / </a>
            <a href="/career_detail/<?php echo e($career->slug); ?>"><?php echo e($career->job_title); ?></a>
        </div>
    </div>
</section>

<!-- ====================================== Career Detail Section ===================================== -->
<section class="blog-section">
    <div class="container">
        <div class="row blog-two-grid-row">
            <!-- Left Side - Job Details -->
            <div class="col-xxl-8 col-xl-8 col-lg-8 col-md-12">
                <div class="job-detail-main">
                    <div class="job-header">
                        <h2 class="job-title"><?php echo e($career->job_title); ?></h2>
                        <div class="job-meta">
                            <div class="job-meta-item">
                                <i class="fas fa-map-marker-alt"></i>
                                <span><?php echo e($career->location); ?></span>
                            </div>
                            <div class="job-meta-item">
                                <i class="fas fa-dollar-sign"></i>
                                <span><?php echo e($career->salary); ?></span>
                            </div>
                            <div class="job-meta-item">
                                <i class="fas fa-briefcase"></i>
                                <span><?php echo e($career->experience); ?></span>
                            </div>
                            <div class="job-meta-item">
                                <i class="fas fa-graduation-cap"></i>
                                <span><?php echo e($career->qualification); ?></span>
                            </div>
                        </div>
                    </div>

                    <div class="job-description">
                        <h3>Job Description</h3>
                        <div class="job-desc-content">
                            <?php echo $career->job_desc; ?>

                        </div>
                    </div>
                </div>
            </div>

            <!-- Right Side - Application Form -->
            <div class="col-xxl-4 col-xl-4 col-lg-4 col-md-8">
                <div class="application-form-container">
                    <div class="single-services-black-box">
                        <h3>Apply for this Position</h3>
                    </div>

                    <!-- Success/Error Messages -->
                    <div id="application-message" class="alert" style="display: none; margin-bottom: 20px; padding: 15px; border-radius: 10px; font-weight: 500;"></div>

                    <form id="application-form" action="<?php echo e(route('career.application.submit')); ?>" method="POST" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="job_id" value="<?php echo e($career->id); ?>">

                        <div class="form-group mb-3">
                            <label for="name" class="form-label">Full Name *</label>
                            <input type="text" class="form-control" id="name" name="name" value="<?php echo e(old('name')); ?>" required>
                            <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="text-danger small mt-1"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="form-group mb-3">
                            <label for="email" class="form-label">Email Address *</label>
                            <input type="email" class="form-control" id="email" name="email" value="<?php echo e(old('email')); ?>" required>
                            <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="text-danger small mt-1"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="form-group mb-3">
                            <label for="mobile" class="form-label">Mobile Number *</label>
                            <input type="text" class="form-control" id="mobile" name="mobile" value="<?php echo e(old('mobile')); ?>" required>
                            <?php $__errorArgs = ['mobile'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="text-danger small mt-1"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="form-group mb-3">
                            <label for="cover_letter" class="form-label">Cover Letter *</label>
                            <textarea class="form-control" id="cover_letter" name="cover_letter" rows="4" required><?php echo e(old('cover_letter')); ?></textarea>
                            <?php $__errorArgs = ['cover_letter'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="text-danger small mt-1"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="form-group mb-3">
                            <label for="resume" class="form-label">Resume (PDF/DOC) *</label>
                            <input type="file" class="form-control" id="resume" name="resume" accept=".pdf,.doc,.docx" required>
                            <?php $__errorArgs = ['resume'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="text-danger small mt-1"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <button type="submit" class="btn-quote w-100" id="submit-btn">
                            <span id="btn-text">Submit Application</span>
                            <span id="btn-loading" style="display: none;">Submitting...</span>
                            <img src="/frontend/assets/images/svg/cross-arrow.svg" alt="cross-arrow">
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</section>

<style>
.job-detail-main {
    background: white;
    border-radius: 15px;
    padding: 30px;
    box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
    margin-bottom: 30px;
}

.job-header {
    border-bottom: 2px solid #f0f0f0;
    padding-bottom: 20px;
    margin-bottom: 30px;
}

.job-title {
    color: #333;
    font-size: 28px;
    font-weight: 600;
    margin-bottom: 15px;
}

.job-meta {
    display: flex;
    flex-wrap: wrap;
    gap: 20px;
}

.job-meta-item {
    display: flex;
    align-items: center;
    gap: 8px;
    color: #666;
    font-size: 14px;
}

.job-meta-item i {
    color: #3c55ab;
    width: 16px;
}

.job-description h3 {
    color: #333;
    font-size: 22px;
    margin-bottom: 20px;
}

.job-desc-content {
    color: #666;
    line-height: 1.8;
}

.application-form-container {
    background: white;
    border-radius: 15px;
    padding: 20px;
    box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
    position: sticky;
    top: 20px;
}

.form-label {
    font-weight: 600;
    color: #333;
    margin-bottom: 8px;
}

.form-control {
    border: 2px solid #f0f0f0;
    border-radius: 10px;
    padding: 12px 15px;
    font-size: 14px;
    transition: border-color 0.3s ease;
}

.form-control:focus {
    border-color: #3c55ab;
    box-shadow: 0 0 0 0.2rem rgba(0, 194, 255, 0.25);
}

.btn-quote {
    background: linear-gradient(135deg, #3c55ab 0%, #0099CC 100%);
    border: none;
    padding: 15px 25px;
    border-radius: 10px;
    color: white;
    font-weight: 600;
    text-decoration: none;
    display: inline-flex;
    align-items: center;
    justify-content: center;
    gap: 10px;
    transition: all 0.3s ease;
    cursor: pointer;
}

.btn-quote:hover {
    transform: translateY(-2px);
    box-shadow: 0 10px 25px rgba(0, 194, 255, 0.3);
    color: white;
    text-decoration: none;
}

@media (max-width: 768px) {
    .job-meta {
        flex-direction: column;
        gap: 10px;
    }

    .job-detail-main {
        padding: 20px;
    }

    .application-form-container {
        margin-top: 30px;
        position: static;
    }
}
</style>

<!-- SweetAlert2 CDN -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const form = document.getElementById('application-form');
    const messageDiv = document.getElementById('application-message');
    const submitBtn = document.getElementById('submit-btn');
    const btnText = document.getElementById('btn-text');
    const btnLoading = document.getElementById('btn-loading');

    form.addEventListener('submit', function(e) {
        e.preventDefault();

        // Show loading state
        submitBtn.disabled = true;
        btnText.style.display = 'none';
        btnLoading.style.display = 'inline';

        // Hide previous messages
        messageDiv.style.display = 'none';

        // Clear previous validation errors
        const errorDivs = form.querySelectorAll('.text-danger');
        errorDivs.forEach(div => div.remove());

        // Prepare form data
        const formData = new FormData(form);

        // Submit form via AJAX
        fetch(form.action, {
            method: 'POST',
            body: formData,
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                // Show SweetAlert success message
                Swal.fire({
                    title: 'Success!',
                    text: data.message,
                    icon: 'success',
                    confirmButtonText: 'OK',
                    confirmButtonColor: '#3c55ab'
                }).then(() => {
                    // Reset form
                    form.reset();
                });
            } else {
                // Show SweetAlert error message
                Swal.fire({
                    title: 'Error!',
                    text: data.message || 'An error occurred. Please try again.',
                    icon: 'error',
                    confirmButtonText: 'OK',
                    confirmButtonColor: '#3c55ab'
                });
            }
        })
        .catch(error => {
            console.error('Error:', error);
            Swal.fire({
                title: 'Error!',
                text: 'An error occurred. Please try again.',
                icon: 'error',
                confirmButtonText: 'OK',
                confirmButtonColor: '#3c55ab'
            });
        })
        .finally(() => {
            // Reset button state
            submitBtn.disabled = false;
            btnText.style.display = 'inline';
            btnLoading.style.display = 'none';
        });
    });
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/koushikkona/Documents/Projects/ses/resources/views/frontend/career_detail.blade.php ENDPATH**/ ?>