<?php $__env->startSection('content'); ?>
<section class="heroSection">
    <div class="container">
        <h1 class="img-header-text fade_down">Career Opportunities</h1>
        <div class="breadcrumb-group fade_up">
            <a href="/">HOME / </a>
            <a href="/career">Career</a>
        </div>
    </div>
</section>

<!-- ====================================== Career Section ===================================== -->
<section class="services-section">
    <div class="container">
        <div class="row services-page-row">
            <?php $__empty_1 = true; $__currentLoopData = $careers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $career): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <div class="col-xxl-4 col-xl-4 col-lg-4 col-md-6 mt-5">
                <div class="cleaning-card career-card">
                    <div class="cleaning-card-img-main">
                        <div class="career-header">
                            <h3 class="career-title"><?php echo e($career->job_title); ?></h3>
                            <div class="career-location">
                                <i class="fas fa-map-marker-alt"></i>
                                <span><?php echo e($career->location); ?></span>
                            </div>
                        </div>
                    </div>
                    <div class="services-svg-main">
                        <img src="/frontend/assets/images/svg/career-icon.svg" alt="career-icon">
                    </div>
                    <div class="card-containe">
                        <div class="career-details">
                            <div class="career-info">
                                <strong>Experience:</strong> <?php echo e($career->experience); ?>

                            </div>
                            <div class="career-info">
                                <strong>Salary:</strong> <?php echo e($career->salary); ?>

                            </div>
                            <div class="career-info">
                                <strong>Qualification:</strong> <?php echo e($career->qualification); ?>

                            </div>
                        </div>
                        <p class="services-card-sub-text"><?php echo e(Str::limit(strip_tags($career->job_desc), 100)); ?></p>
                    </div>
                    <a href="/career_detail/<?php echo e($career->slug); ?>" class="card-learn-more">
                        View Details
                        <img src="/frontend/assets/images/svg/cross-arrow.svg" alt="cross-arrow">
                    </a>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="col-12">
                <div class="text-center">
                    <h3>No Career Opportunities Available</h3>
                    <p>Please check back later for new job openings.</p>
                </div>
            </div>
            <?php endif; ?>
        </div>
    </div>
</section>

<style>
.career-card {
    min-height: 400px;
}

.career-header {
    padding: 20px;
    background: linear-gradient(135deg, #3c55ab 0%, #0099CC 100%);
    color: white;
    border-radius: 15px 15px 0 0;
}

.career-title {
    font-size: 20px;
    font-weight: 600;
    margin-bottom: 10px;
    color: white;
}

.career-location {
    display: flex;
    align-items: center;
    gap: 5px;
    font-size: 14px;
}

.career-details {
    margin-bottom: 15px;
}

.career-info {
    margin-bottom: 8px;
    font-size: 14px;
}

.career-info strong {
    color: #333;
}

.cleaning-card-img-main {
    margin-bottom: 0;
}

.services-svg-main {
    position: absolute;
    top: 120px;
    right: 20px;
    width: 50px;
    height: 50px;
    background: white;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
}

.services-svg-main img {
    width: 25px;
    height: 25px;
}
</style>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/koushikkona/Documents/Projects/ses/resources/views/frontend/career.blade.php ENDPATH**/ ?>