<?php $__env->startSection('content'); ?>
<section class="heroSection">
        <div class="container">
            <h1 class="img-header-text fade_down">Our Blog</h1>
            <div class="breadcrumb-group fade_up">
                <a href="/">HOME / </a>
                <a href="/blog">Blog</a>
            </div>
        </div>
    </section>
    <!-- ====================================== About Section Two ===================================== -->
    <section class="blog-section">
        <div class="container">
            <div class="row blog-two-grid-row">
                <div class="col-xxl-8 col-xl-8 col-lg-8 col-md-12">
                     <div class="row home-blog-row blogPage-row2">
                        <?php $__empty_1 = true; $__currentLoopData = $posts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $post): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <div class="col-xxl-6 col-xl-6 col-lg-6 col-md-6">
                            <a href="/blog_detail/<?php echo e($post->slug); ?>" class="blog-box-main zoom_in">
                                <div class="blog-img-main">
                                    <img class="blog-img" src="<?php echo e(asset('storage/' . $post->image)); ?>" alt="<?php echo e($post->title); ?>">
                                    <h3 class="blog-date"><?php echo e($post->created_at->format('d M Y')); ?></h3>
                                </div>
                                <div class="blog-containe-main">
                                    <h2><?php echo e($post->title); ?></h2>
                                    <p><?php echo e($post->excerpt ?: Str::limit(strip_tags($post->body), 100)); ?></p>
                                </div>
                            </a>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <div class="col-12">
                            <div class="text-center">
                                <p>No blog posts available at the moment.</p>
                            </div>
                        </div>
                        <?php endif; ?>
                    </div>

                    <!-- Pagination -->
                    <?php if($posts->hasPages()): ?>
                    <div class="d-flex justify-content-center mt-4">
                        <?php echo e($posts->appends(request()->query())->links()); ?>

                    </div>
                    <?php endif; ?>
                </div>
                <div class="col-xxl-4 col-xl-4 col-lg-4 col-md-8">
                    <div class="search-box-main">
                        <form method="GET" action="<?php echo e(route('blog')); ?>" class="search-input">
                            <input type="text" placeholder="Search Here..." name="search" value="<?php echo e(request('search')); ?>">
                            <button type="submit" class="search-box" style="border: none; background: none; cursor: pointer;">
                                <img src="/frontend/assets/images/svg/search-icon.svg" alt="search-icon">
                            </button>
                        </form>
                    </div>
                    <div class="single-services-black-box" id="recent-post-box">
                        <h3>Recent Posts</h3>
                    </div>
                    <?php $__empty_1 = true; $__currentLoopData = $recentPosts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $recentPost): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <a href="/blog_detail/<?php echo e($recentPost->slug); ?>" class="recent-post-main">
                        <img src="<?php echo e($recentPost->image ? asset('storage/' . $recentPost->image) : '/frontend/assets/images/blog/default-blog.jpg'); ?>" alt="<?php echo e($recentPost->title); ?>" width="100px">
                        <div class="recent-post-text-main">
                            <p><?php echo e($recentPost->created_at->format('d M Y')); ?></p>
                            <h2><?php echo e(Str::limit($recentPost->title, 50)); ?></h2>
                        </div>
                    </a>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <div class="recent-post-main">
                        <div class="recent-post-text-main">
                            <p>No recent posts available</p>
                        </div>
                    </div>
                    <?php endif; ?>

                    <!-- Categories Section -->
                    <div class="single-services-black-box" id="categories-box">
                        <h3>Categories</h3>
                    </div>
                    <div class="categories-list">
                        <?php $__empty_1 = true; $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <a href="<?php echo e(route('blog', ['category' => $category->id])); ?>" class="category-link">
                                <div class="category-item">
                                    <h4><?php echo e($category->name); ?></h4>
                                    <span class="post-count">(<?php echo e($category->posts()->where('status', 'PUBLISHED')->count()); ?> posts)</span>
                                </div>
                            </a>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <div class="category-item">
                                <p>No categories available</p>
                            </div>
                        <?php endif; ?>
                    </div>

                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/koushikkona/Documents/Projects/ses/resources/views/frontend/blog.blade.php ENDPATH**/ ?>