<?php $__env->startSection('content'); ?>
<section class="heroSection">
        <div class="container">
            <h1 class="img-header-text fade_down"><?php echo e($post->title); ?></h1>
            <div class="breadcrumb-group fade_up">
                <a href="/">HOME / </a>
                <a href="/blog">BLOG / </a>
                <span><?php echo e($post->title); ?></span>
            </div>
        </div>
    </section>
    <!-- ====================================== About Section Two ===================================== -->
    <section class="blog-section">
        <div class="container">
            <div class="row blog-two-grid-row">
                <div class="col-xxl-8 col-xl-8 col-lg-8">
                    <?php if($post->image): ?>
                        <img class="single-blog-img1" src="<?php echo e(Voyager::image($post->image)); ?>" alt="<?php echo e($post->title); ?>" width="911px" height="500px" >
                    <?php endif; ?>
                    <div class="tag-date border-bottom-0">
                        <div class="tag-date-sub">
                            <img class="blog-cal-svg" src="<?php echo e(asset('frontend/assets/images/svg/user-circle.svg')); ?>" alt="user-circle">
                            <p><?php echo e($post->category ? $post->category->name : 'Uncategorized'); ?></p>
                        </div>
                        <div class="tag-date-sub">
                            <img class="blog-cal-svg" src="<?php echo e(asset('frontend/assets/images/svg/calendar-week.svg')); ?>" alt="calendar-week">
                            <p><?php echo e($post->created_at->format('d M Y')); ?></p>
                        </div>
                        
                    </div>
                    <?php if($post->excerpt): ?>
                        <p class="fusce fade_down"><?php echo e($post->excerpt); ?></p>
                    <?php endif; ?>
                    <div class="blog-content fade_down">
                        <?php echo $post->body; ?>

                    </div>

                </div>
                <div class="col-xxl-4 col-xl-4 col-lg-4 col-md-8">
                    <div class="search-box-main">
                        <form action="<?php echo e(route('blog')); ?>" method="GET">
                            <div class="search-input">
                                <input type="text" placeholder="Search Here..." name="search" value="<?php echo e(request('search')); ?>">
                                <button type="submit" class="search-box">
                                    <img src="<?php echo e(asset('frontend/assets/images/svg/search-icon.svg')); ?>" alt="search-icon">
                                </button>
                            </div>
                        </form>
                    </div>
                    <div class="single-services-black-box" id="recent-post-box">
                        <h3>Recent Posts</h3>
                    </div>
                    <?php $__currentLoopData = $allPosts->take(5); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $recentPost): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if($recentPost->id != $post->id): ?>
                            <a href="<?php echo e(route('blog_detail', $recentPost->slug)); ?>" class="recent-post-main">
                                <?php if($recentPost->image): ?>
                                    <img src="<?php echo e(Voyager::image($recentPost->image)); ?>" alt="<?php echo e($recentPost->title); ?>" width="120px" height="90px" >
                                <?php else: ?>
                                    <img src="<?php echo e(asset('frontend/assets/images/blog/default-blog.jpg')); ?>" alt="<?php echo e($recentPost->title); ?>" width="100px" height="100px" >
                                <?php endif; ?>
                                <div class="recent-post-text-main">
                                    <p><?php echo e($recentPost->created_at->format('d M Y')); ?></p>
                                    <h2><?php echo e(Str::limit($recentPost->title, 50)); ?></h2>
                                </div>
                            </a>
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    <!-- Categories Section -->
                    <div class="single-services-black-box" id="categories-box">
                        <h3>Categories</h3>
                    </div>
                    <div class="categories-list">
                        <?php $__empty_1 = true; $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <a href="<?php echo e(route('blog', ['category' => $category->id])); ?>" class="category-link">
                                <div class="category-item">
                                    <h4><?php echo e($category->name); ?></h4>
                                    <span class="post-count">(<?php echo e($category->posts()->where('status', 'PUBLISHED')->count()); ?> posts)</span>
                                </div>
                            </a>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <div class="category-item">
                                <p>No categories available</p>
                            </div>
                        <?php endif; ?>
                    </div>

                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/koushikkona/Documents/Projects/ses/resources/views/frontend/blog_detail.blade.php ENDPATH**/ ?>